<?php
/* This file has been auto-generated. Do not edit this file directly. */

abstract class Sabai_Addon_Taxonomy_Model_Base_TermGateway extends SabaiFramework_Model_TreeGateway
{
    public function getName()
    {
        return 'taxonomy_term';
    }

    public function getFields()
    {
        return array('term_name' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'term_title' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'term_entity_bundle_name' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'term_entity_bundle_type' => SabaiFramework_Model::KEY_TYPE_VARCHAR, 'term_id' => SabaiFramework_Model::KEY_TYPE_INT, 'term_created' => SabaiFramework_Model::KEY_TYPE_INT, 'term_updated' => SabaiFramework_Model::KEY_TYPE_INT, 'term_parent' => SabaiFramework_Model::KEY_TYPE_INT, 'term_user_id' => SabaiFramework_Model::KEY_TYPE_INT);
    }

    protected function _getIdFieldName()
    {
        return 'term_id';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %staxonomy_term WHERE term_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %staxonomy_term WHERE term_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$staxonomy_term taxonomy_term WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['term_created'] = time();
        $values['term_updated'] = 0;
        return sprintf('INSERT INTO %staxonomy_term(term_name, term_title, term_entity_bundle_name, term_entity_bundle_type, term_id, term_created, term_updated, term_parent, term_user_id) VALUES(%s, %s, %s, %s, %s, %d, %d, %d, %d)', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['term_name']), $this->_db->escapeString($values['term_title']), $this->_db->escapeString($values['term_entity_bundle_name']), $this->_db->escapeString($values['term_entity_bundle_type']), empty($values['term_id']) ? 'NULL' : intval($values['term_id']), $values['term_created'], $values['term_updated'], $values['term_parent'], $values['term_user_id']);
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['term_updated'];
        $values['term_updated'] = time();
        return sprintf('UPDATE %staxonomy_term SET term_name = %s, term_title = %s, term_entity_bundle_name = %s, term_entity_bundle_type = %s, term_updated = %d, term_parent = %d, term_user_id = %d WHERE term_id = %d AND term_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString($values['term_name']), $this->_db->escapeString($values['term_title']), $this->_db->escapeString($values['term_entity_bundle_name']), $this->_db->escapeString($values['term_entity_bundle_type']), $values['term_updated'], $values['term_parent'], $values['term_user_id'], $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$staxonomy_term WHERE term_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['term_updated'] = 'term_updated=' . time();
        return sprintf('UPDATE %staxonomy_term taxonomy_term SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE taxonomy_term FROM %1$staxonomy_term taxonomy_term WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$staxonomy_term taxonomy_term WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getSelectDescendantsQuery($id, $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t2.', $fields);
        return sprintf('SELECT t2.%3$s FROM %1$staxonomy_term_tree t1 INNER JOIN %1$staxonomy_term t2 ON t1.tree_descendant = t2.term_id WHERE t1.tree_ancestor = %2$d AND t1.tree_descendant <> %2$d', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getCountDescendantsQuery($id)
    {
        return sprintf('SELECT COUNT(*) FROM %1$staxonomy_term_tree WHERE tree_ancestor = %2$d AND tree_descendant <> %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getCountDescendantsByIdsQuery($ids)
    {
        return sprintf('SELECT tree_ancestor, COUNT(*) - 1 FROM %1$staxonomy_term_tree WHERE tree_ancestor IN(%2$s) GROUP BY tree_ancestor', $this->_db->getResourcePrefix(), implode(', ', $ids));
    }

    protected function _getSelectParentsQuery($id, $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t2.', $fields);
        return sprintf('SELECT t2.%3$s FROM %1$staxonomy_term_tree t1 INNER JOIN %1$staxonomy_term t2 ON t1.tree_ancestor = t2.term_id WHERE t1.tree_descendant = %2$d AND t1.tree_ancestor <> %2$d', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getCountParentsQuery($id)
    {
        return sprintf('SELECT COUNT(*) FROM %1$staxonomy_term_tree WHERE tree_descendant = %2$d AND tree_ancestor <> %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getCountParentsByIdsQuery($ids)
    {
        return sprintf('SELECT tree_descendant, COUNT(*) - 1 FROM %1$staxonomy_term_tree WHERE tree_descendant IN(%2$s) GROUP BY tree_descendant', $this->_db->getResourcePrefix(), implode(', ', $ids));
    }

    protected function _afterInsert1($id, array $new)
    {
        if (!empty($new['term_parent'])) {
            $sql = sprintf(
                'INSERT INTO %1$staxonomy_term_tree (tree_ancestor, tree_descendant, tree_path_length)
                   SELECT tree_ancestor, %2$d, tree_path_length + 1 FROM %1$staxonomy_term_tree WHERE tree_descendant = %3$d
                  UNION ALL SELECT %2$d, %2$d, 0',
                $this->_db->getResourcePrefix(),
                $id,
                $new['term_parent']
            );
        } else {
            $sql = sprintf(
                'INSERT INTO %1$staxonomy_term_tree (tree_ancestor, tree_descendant, tree_path_length) VALUES (%2$d, %2$d, 0)',
                $this->_db->getResourcePrefix(),
                $id
            );
        }
        $this->_db->exec($sql);
    }

    protected function _beforeDelete1($id, array $old)
    {
        // Check if any descendants
        $sql = sprintf('SELECT COUNT(*) FROM %staxonomy_term_tree WHERE tree_ancestor = %d', $this->_db->getResourcePrefix(), $old['term_id']);
        if ($this->_db->query($sql)->fetchSingle() === 0) {
            return;
        }
        // Move all descendants up 1 level 
        $this->_db->exec(sprintf('UPDATE %1$staxonomy_term_tree SET tree_path_length = tree_path_length -1 WHERE tree_path_length > 0 AND tree_descendant IN (SELECT tree_descendant1 FROM (SELECT DISTINCT tree_descendant AS tree_descendant1 FROM %1$staxonomy_term_tree WHERE tree_ancestor = %d) AS tree_descendant2)', $this->_db->getResourcePrefix(), $old['term_id']));
        // Remove paths referencing old parent
        $this->_db->exec(sprintf('DELETE FROM %staxonomy_term_tree WHERE tree_ancestor = %d', $this->_db->getResourcePrefix(), $old['term_id']));
        // Update parent ID on the main table
        $this->_db->exec(sprintf('UPDATE %staxonomy_term SET term_parent = %d WHERE term_parent = %d', $this->_db->getResourcePrefix(), $old['term_parent'], $old['term_id']));
    }

    protected function _afterDelete1($id, array $old)
    {
        $this->_db->exec(sprintf('DELETE FROM %staxonomy_term_tree WHERE tree_descendant = %d', $this->_db->getResourcePrefix(), $id));
    }

    protected function _beforeUpdate1($id, array &$new, array $old)
    {
        if (!empty($new['term_parent'])) {
            if ($new['term_parent'] == $id) {
                throw new SabaiFramework_Exception('The parent entity may not be the entity itself.');
            }
            $sql = sprintf('SELECT COUNT(*) FROM %staxonomy_term_tree WHERE tree_descendant = %d AND tree_ancestor = %d', $this->_db->getResourcePrefix(), $new['term_parent'], $id);
            if ($this->_db->query($sql)->fetchSingle() > 0) {
                throw new SabaiFramework_Exception('The parent entity may not be one of the current decendant entities.');
            }
        }
    }

    protected function _afterUpdate1($id, array $new, array $old)
    {
        if (!empty($new['term_parent'])) {
            if (empty($old['term_parent']) || $new['term_parent'] != $old['term_parent']) {
                $sql = sprintf(
                    'DELETE FROM %1$staxonomy_term_tree WHERE tree_descendant IN (SELECT tree_descendant FROM (SELECT * FROM %1$staxonomy_term_tree WHERE tree_ancestor = %2$d) AS temp1)
                       AND tree_ancestor IN (SELECT tree_ancestor FROM (SELECT * FROM %1$staxonomy_term_tree WHERE tree_descendant = %2$d AND tree_ancestor != tree_descendant) AS temp2)',
                    $this->_db->getResourcePrefix(),
                    $id
                );
                $this->_db->exec($sql);

                $sql = sprintf(
                    'INSERT INTO %1$staxonomy_term_tree (tree_ancestor, tree_descendant, tree_path_length)
                       SELECT t1.tree_ancestor, t2.tree_descendant, t1.tree_path_length + t2.tree_path_length + 1
                         FROM %1$staxonomy_term_tree t1
                           CROSS JOIN %1$staxonomy_term_tree t2
                         WHERE t1.tree_descendant = %2$d
                           AND t2.tree_ancestor = %3$d',
                    $this->_db->getResourcePrefix(),
                    $new['term_parent'],
                    $id
                );
                $this->_db->exec($sql);
            }
        } else {
            if (!empty($old['term_parent'])) {
                $sql = sprintf(
                    'DELETE FROM %1$staxonomy_term_tree WHERE tree_descendant IN (SELECT tree_descendant FROM (SELECT * FROM %1$staxonomy_term_tree WHERE tree_ancestor = %2$d) AS temp1)
                       AND tree_ancestor IN (SELECT tree_ancestor FROM (SELECT * FROM %1$staxonomy_term_tree WHERE tree_descendant = %2$d AND tree_ancestor != tree_descendant) AS temp2)',
                    $this->_db->getResourcePrefix(),
                    $id
                );
                $this->_db->exec($sql);
            }
        }
    }

    protected function _afterInsert($id, array $new)
    {
        $this->_afterInsert1($id, $new);
    }

    protected function _beforeUpdate($id, array &$new, array $old)
    {
        $this->_beforeUpdate1($id, $new, $old);
    }

    protected function _afterUpdate($id, array $new, array $old)
    {
        $this->_afterUpdate1($id, $new, $old);
    }

    protected function _beforeDelete($id, array $old)
    {
        $this->_beforeDelete1($id, $old);
    }

    protected function _afterDelete($id, array $old)
    {
        $this->_afterDelete1($id, $old);
    }
}